--
-- Table structure for table `#__layerslider`
--

CREATE TABLE IF NOT EXISTS `#__layerslider` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `author` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int unsigned NOT NULL,
  `date_m` int unsigned NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `schedule_start` int unsigned NOT NULL DEFAULT 0,
  `schedule_end` int unsigned NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__layerslider_revisions`
--

CREATE TABLE IF NOT EXISTS `#__layerslider_revisions` (
  id int unsigned NOT NULL AUTO_INCREMENT,
  slider_id int unsigned NOT NULL,
  author int unsigned NOT NULL DEFAULT 0,
  data mediumtext NOT NULL,
  date_c int unsigned NOT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__layerslider_options`
--

CREATE TABLE IF NOT EXISTS `#__layerslider_options` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL,
  `option_value` text NOT NULL,
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Init Google Fonts options
--

INSERT IGNORE INTO `#__layerslider_options` (`option_name`, `option_value`) VALUES (
  'ls-google-fonts',
  '[{"param":"Lato:100,300,regular,700,900","admin":false},{"param":"Open+Sans:300","admin":false},{"param":"Indie+Flower:regular","admin":false},{"param":"Oswald:300,regular,700","admin":false}]'
);

--
-- Enable plugins
--

UPDATE `#__extensions` SET enabled=1 WHERE type LIKE 'plugin' AND element LIKE 'layer_slider';
