<?php
/**
 * com_layer_slider - Creative Slider
 *
 * @author    John Gera, George Krupa, Janos Biro, Balint Polgarfi
 * @copyright (c) 2014-2022 Offlajn.com - All Rights Reserved
 * @license   https://www.gnu.org/licenses/gpl-2.0.html
 */

namespace CreativeSlider;

defined('_JEXEC') or die;
?>
<script type="text/html" id="tmpl-insert-icons-modal">
	<div id="ls-insert-icons-modal-window">
		<header>
			<h1><?php _e('Insert Icon', 'LayerSlider') ?></h1>
			<b class="dashicons dashicons-no"></b>
		</header>
		<div class="km-ui-modal-scrollable">
			<div class="search-holder">
				<input type="search" name="s" placeholder="<?php _e('Search icons ...', 'LayerSlider') ?>">
			</div>
			<div class="results">


				<!-- Web Application Icons -->
				<h2><?php _e('Web Application Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="address-book"><i class="fa fa-address-book"></i></div>
					<div data-help="address-book-o"><i class="fa fa-address-book-o"></i></div>
					<div data-help="address-card"><i class="fa fa-address-card"></i></div>
					<div data-help="address-card-o"><i class="fa fa-address-card-o"></i></div>
					<div data-help="adjust"><i class="fa fa-adjust"></i></div>
					<div data-help="american-sign-language-interpreting"><i class="fa fa-american-sign-language-interpreting"></i></div>
					<div data-help="anchor"><i class="fa fa-anchor"></i></div>
					<div data-help="archive"><i class="fa fa-archive"></i></div>
					<div data-help="area-chart"><i class="fa fa-area-chart"></i></div>
					<div data-help="arrows"><i class="fa fa-arrows"></i></div>
					<div data-help="arrows-h"><i class="fa fa-arrows-h"></i></div>
					<div data-help="arrows-v"><i class="fa fa-arrows-v"></i></div>
					<div data-help="american-sign-language-interpreting"><i class="fa fa-american-sign-language-interpreting"></i></div>
					<div data-help="assistive-listening-systems"><i class="fa fa-assistive-listening-systems"></i></div>
					<div data-help="asterisk"><i class="fa fa-asterisk"></i></div>
					<div data-help="at"><i class="fa fa-at"></i></div>
					<div data-help="audio-description"><i class="fa fa-audio-description"></i></div>
					<div data-help="car"><i class="fa fa-car"></i></div>
					<div data-help="balance-scale"><i class="fa fa-balance-scale"></i></div>
					<div data-help="ban"><i class="fa fa-ban"></i></div>
					<div data-help="university"><i class="fa fa-university"></i></div>
					<div data-help="bar-chart"><i class="fa fa-bar-chart"></i></div>
					<div data-help="bar-chart"><i class="fa fa-bar-chart"></i></div>
					<div data-help="barcode"><i class="fa fa-barcode"></i></div>
					<div data-help="bars"><i class="fa fa-bars"></i></div>
					<div data-help="bath"><i class="fa fa-bath"></i></div>
					<div data-help="bath"><i class="fa fa-bath"></i></div>
					<div data-help="battery-full"><i class="fa fa-battery-full"></i></div>
					<div data-help="battery-empty"><i class="fa fa-battery-empty"></i></div>
					<div data-help="battery-quarter"><i class="fa fa-battery-quarter"></i></div>
					<div data-help="battery-half"><i class="fa fa-battery-half"></i></div>
					<div data-help="battery-three-quarters"><i class="fa fa-battery-three-quarters"></i></div>
					<div data-help="battery-full"><i class="fa fa-battery-full"></i></div>
					<div data-help="battery-empty"><i class="fa fa-battery-empty"></i></div>
					<div data-help="battery-full"><i class="fa fa-battery-full"></i></div>
					<div data-help="battery-half"><i class="fa fa-battery-half"></i></div>
					<div data-help="battery-quarter"><i class="fa fa-battery-quarter"></i></div>
					<div data-help="battery-three-quarters"><i class="fa fa-battery-three-quarters"></i></div>
					<div data-help="bed"><i class="fa fa-bed"></i></div>
					<div data-help="beer"><i class="fa fa-beer"></i></div>
					<div data-help="bell"><i class="fa fa-bell"></i></div>
					<div data-help="bell-o"><i class="fa fa-bell-o"></i></div>
					<div data-help="bell-slash"><i class="fa fa-bell-slash"></i></div>
					<div data-help="bell-slash-o"><i class="fa fa-bell-slash-o"></i></div>
					<div data-help="bicycle"><i class="fa fa-bicycle"></i></div>
					<div data-help="binoculars"><i class="fa fa-binoculars"></i></div>
					<div data-help="birthday-cake"><i class="fa fa-birthday-cake"></i></div>
					<div data-help="blind"><i class="fa fa-blind"></i></div>
					<div data-help="bluetooth"><i class="fa fa-bluetooth"></i></div>
					<div data-help="bluetooth-b"><i class="fa fa-bluetooth-b"></i></div>
					<div data-help="bolt"><i class="fa fa-bolt"></i></div>
					<div data-help="bomb"><i class="fa fa-bomb"></i></div>
					<div data-help="book"><i class="fa fa-book"></i></div>
					<div data-help="bookmark"><i class="fa fa-bookmark"></i></div>
					<div data-help="bookmark-o"><i class="fa fa-bookmark-o"></i></div>
					<div data-help="braille"><i class="fa fa-braille"></i></div>
					<div data-help="briefcase"><i class="fa fa-briefcase"></i></div>
					<div data-help="bug"><i class="fa fa-bug"></i></div>
					<div data-help="building"><i class="fa fa-building"></i></div>
					<div data-help="building-o"><i class="fa fa-building-o"></i></div>
					<div data-help="bullhorn"><i class="fa fa-bullhorn"></i></div>
					<div data-help="bullseye"><i class="fa fa-bullseye"></i></div>
					<div data-help="bus"><i class="fa fa-bus"></i></div>
					<div data-help="taxi"><i class="fa fa-taxi"></i></div>
					<div data-help="calculator"><i class="fa fa-calculator"></i></div>
					<div data-help="calendar"><i class="fa fa-calendar"></i></div>
					<div data-help="calendar-check-o"><i class="fa fa-calendar-check-o"></i></div>
					<div data-help="calendar-minus-o"><i class="fa fa-calendar-minus-o"></i></div>
					<div data-help="calendar-o"><i class="fa fa-calendar-o"></i></div>
					<div data-help="calendar-plus-o"><i class="fa fa-calendar-plus-o"></i></div>
					<div data-help="calendar-times-o"><i class="fa fa-calendar-times-o"></i></div>
					<div data-help="camera"><i class="fa fa-camera"></i></div>
					<div data-help="camera-retro"><i class="fa fa-camera-retro"></i></div>
					<div data-help="car"><i class="fa fa-car"></i></div>
					<div data-help="caret-square-o-down"><i class="fa fa-caret-square-o-down"></i></div>
					<div data-help="caret-square-o-left"><i class="fa fa-caret-square-o-left"></i></div>
					<div data-help="caret-square-o-right"><i class="fa fa-caret-square-o-right"></i></div>
					<div data-help="caret-square-o-up"><i class="fa fa-caret-square-o-up"></i></div>
					<div data-help="cart-arrow-down"><i class="fa fa-cart-arrow-down"></i></div>
					<div data-help="cart-plus"><i class="fa fa-cart-plus"></i></div>
					<div data-help="cc"><i class="fa fa-cc"></i></div>
					<div data-help="certificate"><i class="fa fa-certificate"></i></div>
					<div data-help="check"><i class="fa fa-check"></i></div>
					<div data-help="check-circle"><i class="fa fa-check-circle"></i></div>
					<div data-help="check-circle-o"><i class="fa fa-check-circle-o"></i></div>
					<div data-help="check-square"><i class="fa fa-check-square"></i></div>
					<div data-help="check-square-o"><i class="fa fa-check-square-o"></i></div>
					<div data-help="child"><i class="fa fa-child"></i></div>
					<div data-help="circle"><i class="fa fa-circle"></i></div>
					<div data-help="circle-o"><i class="fa fa-circle-o"></i></div>
					<div data-help="circle-o-notch"><i class="fa fa-circle-o-notch"></i></div>
					<div data-help="circle-thin"><i class="fa fa-circle-thin"></i></div>
					<div data-help="clock-o"><i class="fa fa-clock-o"></i></div>
					<div data-help="clone"><i class="fa fa-clone"></i></div>
					<div data-help="times"><i class="fa fa-times"></i></div>
					<div data-help="cloud"><i class="fa fa-cloud"></i></div>
					<div data-help="cloud-download"><i class="fa fa-cloud-download"></i></div>
					<div data-help="cloud-upload"><i class="fa fa-cloud-upload"></i></div>
					<div data-help="code"><i class="fa fa-code"></i></div>
					<div data-help="code-fork"><i class="fa fa-code-fork"></i></div>
					<div data-help="coffee"><i class="fa fa-coffee"></i></div>
					<div data-help="cog"><i class="fa fa-cog"></i></div>
					<div data-help="cogs"><i class="fa fa-cogs"></i></div>
					<div data-help="comment"><i class="fa fa-comment"></i></div>
					<div data-help="comment-o"><i class="fa fa-comment-o"></i></div>
					<div data-help="commenting"><i class="fa fa-commenting"></i></div>
					<div data-help="commenting-o"><i class="fa fa-commenting-o"></i></div>
					<div data-help="comments"><i class="fa fa-comments"></i></div>
					<div data-help="comments-o"><i class="fa fa-comments-o"></i></div>
					<div data-help="compass"><i class="fa fa-compass"></i></div>
					<div data-help="copyright"><i class="fa fa-copyright"></i></div>
					<div data-help="creative-commons"><i class="fa fa-creative-commons"></i></div>
					<div data-help="credit-card"><i class="fa fa-credit-card"></i></div>
					<div data-help="credit-card-alt"><i class="fa fa-credit-card-alt"></i></div>
					<div data-help="crop"><i class="fa fa-crop"></i></div>
					<div data-help="crosshairs"><i class="fa fa-crosshairs"></i></div>
					<div data-help="cube"><i class="fa fa-cube"></i></div>
					<div data-help="cubes"><i class="fa fa-cubes"></i></div>
					<div data-help="cutlery"><i class="fa fa-cutlery"></i></div>
					<div data-help="tachometer"><i class="fa fa-tachometer"></i></div>
					<div data-help="database"><i class="fa fa-database"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="desktop"><i class="fa fa-desktop"></i></div>
					<div data-help="diamond"><i class="fa fa-diamond"></i></div>
					<div data-help="dot-circle-o"><i class="fa fa-dot-circle-o"></i></div>
					<div data-help="download"><i class="fa fa-download"></i></div>
					<div data-help="id-card"><i class="fa fa-id-card"></i></div>
					<div data-help="id-card-o"><i class="fa fa-id-card-o"></i></div>
					<div data-help="pencil-square-o"><i class="fa fa-pencil-square-o"></i></div>
					<div data-help="ellipsis-h"><i class="fa fa-ellipsis-h"></i></div>
					<div data-help="ellipsis-v"><i class="fa fa-ellipsis-v"></i></div>
					<div data-help="envelope"><i class="fa fa-envelope"></i></div>
					<div data-help="envelope-o"><i class="fa fa-envelope-o"></i></div>
					<div data-help="envelope-open"><i class="fa fa-envelope-open"></i></div>
					<div data-help="envelope-open-o"><i class="fa fa-envelope-open-o"></i></div>
					<div data-help="envelope-square"><i class="fa fa-envelope-square"></i></div>
					<div data-help="eraser"><i class="fa fa-eraser"></i></div>
					<div data-help="exchange"><i class="fa fa-exchange"></i></div>
					<div data-help="exclamation"><i class="fa fa-exclamation"></i></div>
					<div data-help="exclamation-circle"><i class="fa fa-exclamation-circle"></i></div>
					<div data-help="exclamation-triangle"><i class="fa fa-exclamation-triangle"></i></div>
					<div data-help="external-link"><i class="fa fa-external-link"></i></div>
					<div data-help="external-link-square"><i class="fa fa-external-link-square"></i></div>
					<div data-help="eye"><i class="fa fa-eye"></i></div>
					<div data-help="eye-slash"><i class="fa fa-eye-slash"></i></div>
					<div data-help="eyedropper"><i class="fa fa-eyedropper"></i></div>
					<div data-help="fax"><i class="fa fa-fax"></i></div>
					<div data-help="rss"><i class="fa fa-rss"></i></div>
					<div data-help="female"><i class="fa fa-female"></i></div>
					<div data-help="fighter-jet"><i class="fa fa-fighter-jet"></i></div>
					<div data-help="file-archive-o"><i class="fa fa-file-archive-o"></i></div>
					<div data-help="file-audio-o"><i class="fa fa-file-audio-o"></i></div>
					<div data-help="file-code-o"><i class="fa fa-file-code-o"></i></div>
					<div data-help="file-excel-o"><i class="fa fa-file-excel-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-video-o"><i class="fa fa-file-video-o"></i></div>
					<div data-help="file-pdf-o"><i class="fa fa-file-pdf-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-powerpoint-o"><i class="fa fa-file-powerpoint-o"></i></div>
					<div data-help="file-audio-o"><i class="fa fa-file-audio-o"></i></div>
					<div data-help="file-video-o"><i class="fa fa-file-video-o"></i></div>
					<div data-help="file-word-o"><i class="fa fa-file-word-o"></i></div>
					<div data-help="file-archive-o"><i class="fa fa-file-archive-o"></i></div>
					<div data-help="film"><i class="fa fa-film"></i></div>
					<div data-help="filter"><i class="fa fa-filter"></i></div>
					<div data-help="fire"><i class="fa fa-fire"></i></div>
					<div data-help="fire-extinguisher"><i class="fa fa-fire-extinguisher"></i></div>
					<div data-help="flag"><i class="fa fa-flag"></i></div>
					<div data-help="flag-checkered"><i class="fa fa-flag-checkered"></i></div>
					<div data-help="flag-o"><i class="fa fa-flag-o"></i></div>
					<div data-help="bolt"><i class="fa fa-bolt"></i></div>
					<div data-help="flask"><i class="fa fa-flask"></i></div>
					<div data-help="folder"><i class="fa fa-folder"></i></div>
					<div data-help="folder-o"><i class="fa fa-folder-o"></i></div>
					<div data-help="folder-open"><i class="fa fa-folder-open"></i></div>
					<div data-help="folder-open-o"><i class="fa fa-folder-open-o"></i></div>
					<div data-help="frown-o"><i class="fa fa-frown-o"></i></div>
					<div data-help="futbol-o"><i class="fa fa-futbol-o"></i></div>
					<div data-help="gamepad"><i class="fa fa-gamepad"></i></div>
					<div data-help="gavel"><i class="fa fa-gavel"></i></div>
					<div data-help="cog"><i class="fa fa-cog"></i></div>
					<div data-help="cogs"><i class="fa fa-cogs"></i></div>
					<div data-help="gift"><i class="fa fa-gift"></i></div>
					<div data-help="glass"><i class="fa fa-glass"></i></div>
					<div data-help="globe"><i class="fa fa-globe"></i></div>
					<div data-help="graduation-cap"><i class="fa fa-graduation-cap"></i></div>
					<div data-help="users"><i class="fa fa-users"></i></div>
					<div data-help="hand-rock-o"><i class="fa fa-hand-rock-o"></i></div>
					<div data-help="hand-lizard-o"><i class="fa fa-hand-lizard-o"></i></div>
					<div data-help="hand-paper-o"><i class="fa fa-hand-paper-o"></i></div>
					<div data-help="hand-peace-o"><i class="fa fa-hand-peace-o"></i></div>
					<div data-help="hand-pointer-o"><i class="fa fa-hand-pointer-o"></i></div>
					<div data-help="hand-rock-o"><i class="fa fa-hand-rock-o"></i></div>
					<div data-help="hand-scissors-o"><i class="fa fa-hand-scissors-o"></i></div>
					<div data-help="hand-spock-o"><i class="fa fa-hand-spock-o"></i></div>
					<div data-help="hand-paper-o"><i class="fa fa-hand-paper-o"></i></div>
					<div data-help="handshake-o"><i class="fa fa-handshake-o"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="hashtag"><i class="fa fa-hashtag"></i></div>
					<div data-help="hdd-o"><i class="fa fa-hdd-o"></i></div>
					<div data-help="headphones"><i class="fa fa-headphones"></i></div>
					<div data-help="heart"><i class="fa fa-heart"></i></div>
					<div data-help="heart-o"><i class="fa fa-heart-o"></i></div>
					<div data-help="heartbeat"><i class="fa fa-heartbeat"></i></div>
					<div data-help="history"><i class="fa fa-history"></i></div>
					<div data-help="home"><i class="fa fa-home"></i></div>
					<div data-help="bed"><i class="fa fa-bed"></i></div>
					<div data-help="hourglass"><i class="fa fa-hourglass"></i></div>
					<div data-help="hourglass-start"><i class="fa fa-hourglass-start"></i></div>
					<div data-help="hourglass-half"><i class="fa fa-hourglass-half"></i></div>
					<div data-help="hourglass-end"><i class="fa fa-hourglass-end"></i></div>
					<div data-help="hourglass-end"><i class="fa fa-hourglass-end"></i></div>
					<div data-help="hourglass-half"><i class="fa fa-hourglass-half"></i></div>
					<div data-help="hourglass-o"><i class="fa fa-hourglass-o"></i></div>
					<div data-help="hourglass-start"><i class="fa fa-hourglass-start"></i></div>
					<div data-help="i-cursor"><i class="fa fa-i-cursor"></i></div>
					<div data-help="id-badge"><i class="fa fa-id-badge"></i></div>
					<div data-help="id-card"><i class="fa fa-id-card"></i></div>
					<div data-help="id-card-o"><i class="fa fa-id-card-o"></i></div>
					<div data-help="picture-o"><i class="fa fa-picture-o"></i></div>
					<div data-help="inbox"><i class="fa fa-inbox"></i></div>
					<div data-help="industry"><i class="fa fa-industry"></i></div>
					<div data-help="info"><i class="fa fa-info"></i></div>
					<div data-help="info-circle"><i class="fa fa-info-circle"></i></div>
					<div data-help="university"><i class="fa fa-university"></i></div>
					<div data-help="key"><i class="fa fa-key"></i></div>
					<div data-help="keyboard-o"><i class="fa fa-keyboard-o"></i></div>
					<div data-help="language"><i class="fa fa-language"></i></div>
					<div data-help="laptop"><i class="fa fa-laptop"></i></div>
					<div data-help="leaf"><i class="fa fa-leaf"></i></div>
					<div data-help="gavel"><i class="fa fa-gavel"></i></div>
					<div data-help="lemon-o"><i class="fa fa-lemon-o"></i></div>
					<div data-help="level-down"><i class="fa fa-level-down"></i></div>
					<div data-help="level-up"><i class="fa fa-level-up"></i></div>
					<div data-help="life-ring"><i class="fa fa-life-ring"></i></div>
					<div data-help="life-ring"><i class="fa fa-life-ring"></i></div>
					<div data-help="life-ring"><i class="fa fa-life-ring"></i></div>
					<div data-help="life-ring"><i class="fa fa-life-ring"></i></div>
					<div data-help="lightbulb-o"><i class="fa fa-lightbulb-o"></i></div>
					<div data-help="line-chart"><i class="fa fa-line-chart"></i></div>
					<div data-help="location-arrow"><i class="fa fa-location-arrow"></i></div>
					<div data-help="lock"><i class="fa fa-lock"></i></div>
					<div data-help="low-vision"><i class="fa fa-low-vision"></i></div>
					<div data-help="magic"><i class="fa fa-magic"></i></div>
					<div data-help="magnet"><i class="fa fa-magnet"></i></div>
					<div data-help="share"><i class="fa fa-share"></i></div>
					<div data-help="reply"><i class="fa fa-reply"></i></div>
					<div data-help="reply-all"><i class="fa fa-reply-all"></i></div>
					<div data-help="male"><i class="fa fa-male"></i></div>
					<div data-help="map"><i class="fa fa-map"></i></div>
					<div data-help="map-marker"><i class="fa fa-map-marker"></i></div>
					<div data-help="map-o"><i class="fa fa-map-o"></i></div>
					<div data-help="map-pin"><i class="fa fa-map-pin"></i></div>
					<div data-help="map-signs"><i class="fa fa-map-signs"></i></div>
					<div data-help="meh-o"><i class="fa fa-meh-o"></i></div>
					<div data-help="microchip"><i class="fa fa-microchip"></i></div>
					<div data-help="microphone"><i class="fa fa-microphone"></i></div>
					<div data-help="microphone-slash"><i class="fa fa-microphone-slash"></i></div>
					<div data-help="minus"><i class="fa fa-minus"></i></div>
					<div data-help="minus-circle"><i class="fa fa-minus-circle"></i></div>
					<div data-help="minus-square"><i class="fa fa-minus-square"></i></div>
					<div data-help="minus-square-o"><i class="fa fa-minus-square-o"></i></div>
					<div data-help="mobile"><i class="fa fa-mobile"></i></div>
					<div data-help="mobile"><i class="fa fa-mobile"></i></div>
					<div data-help="money"><i class="fa fa-money"></i></div>
					<div data-help="moon-o"><i class="fa fa-moon-o"></i></div>
					<div data-help="graduation-cap"><i class="fa fa-graduation-cap"></i></div>
					<div data-help="motorcycle"><i class="fa fa-motorcycle"></i></div>
					<div data-help="mouse-pointer"><i class="fa fa-mouse-pointer"></i></div>
					<div data-help="music"><i class="fa fa-music"></i></div>
					<div data-help="bars"><i class="fa fa-bars"></i></div>
					<div data-help="newspaper-o"><i class="fa fa-newspaper-o"></i></div>
					<div data-help="object-group"><i class="fa fa-object-group"></i></div>
					<div data-help="object-ungroup"><i class="fa fa-object-ungroup"></i></div>
					<div data-help="paint-brush"><i class="fa fa-paint-brush"></i></div>
					<div data-help="paper-plane"><i class="fa fa-paper-plane"></i></div>
					<div data-help="paper-plane-o"><i class="fa fa-paper-plane-o"></i></div>
					<div data-help="paw"><i class="fa fa-paw"></i></div>
					<div data-help="pencil"><i class="fa fa-pencil"></i></div>
					<div data-help="pencil-square"><i class="fa fa-pencil-square"></i></div>
					<div data-help="pencil-square-o"><i class="fa fa-pencil-square-o"></i></div>
					<div data-help="percent"><i class="fa fa-percent"></i></div>
					<div data-help="phone"><i class="fa fa-phone"></i></div>
					<div data-help="phone-square"><i class="fa fa-phone-square"></i></div>
					<div data-help="picture-o"><i class="fa fa-picture-o"></i></div>
					<div data-help="picture-o"><i class="fa fa-picture-o"></i></div>
					<div data-help="pie-chart"><i class="fa fa-pie-chart"></i></div>
					<div data-help="plane"><i class="fa fa-plane"></i></div>
					<div data-help="plug"><i class="fa fa-plug"></i></div>
					<div data-help="plus"><i class="fa fa-plus"></i></div>
					<div data-help="plus-circle"><i class="fa fa-plus-circle"></i></div>
					<div data-help="plus-square"><i class="fa fa-plus-square"></i></div>
					<div data-help="plus-square-o"><i class="fa fa-plus-square-o"></i></div>
					<div data-help="podcast"><i class="fa fa-podcast"></i></div>
					<div data-help="power-off"><i class="fa fa-power-off"></i></div>
					<div data-help="print"><i class="fa fa-print"></i></div>
					<div data-help="puzzle-piece"><i class="fa fa-puzzle-piece"></i></div>
					<div data-help="qrcode"><i class="fa fa-qrcode"></i></div>
					<div data-help="question"><i class="fa fa-question"></i></div>
					<div data-help="question-circle"><i class="fa fa-question-circle"></i></div>
					<div data-help="question-circle-o"><i class="fa fa-question-circle-o"></i></div>
					<div data-help="quote-left"><i class="fa fa-quote-left"></i></div>
					<div data-help="quote-right"><i class="fa fa-quote-right"></i></div>
					<div data-help="random"><i class="fa fa-random"></i></div>
					<div data-help="recycle"><i class="fa fa-recycle"></i></div>
					<div data-help="refresh"><i class="fa fa-refresh"></i></div>
					<div data-help="registered"><i class="fa fa-registered"></i></div>
					<div data-help="times"><i class="fa fa-times"></i></div>
					<div data-help="bars"><i class="fa fa-bars"></i></div>
					<div data-help="reply"><i class="fa fa-reply"></i></div>
					<div data-help="reply-all"><i class="fa fa-reply-all"></i></div>
					<div data-help="retweet"><i class="fa fa-retweet"></i></div>
					<div data-help="road"><i class="fa fa-road"></i></div>
					<div data-help="rocket"><i class="fa fa-rocket"></i></div>
					<div data-help="rss"><i class="fa fa-rss"></i></div>
					<div data-help="rss-square"><i class="fa fa-rss-square"></i></div>
					<div data-help="bath"><i class="fa fa-bath"></i></div>
					<div data-help="search"><i class="fa fa-search"></i></div>
					<div data-help="search-minus"><i class="fa fa-search-minus"></i></div>
					<div data-help="search-plus"><i class="fa fa-search-plus"></i></div>
					<div data-help="paper-plane"><i class="fa fa-paper-plane"></i></div>
					<div data-help="paper-plane-o"><i class="fa fa-paper-plane-o"></i></div>
					<div data-help="server"><i class="fa fa-server"></i></div>
					<div data-help="share"><i class="fa fa-share"></i></div>
					<div data-help="share-alt"><i class="fa fa-share-alt"></i></div>
					<div data-help="share-alt-square"><i class="fa fa-share-alt-square"></i></div>
					<div data-help="share-square"><i class="fa fa-share-square"></i></div>
					<div data-help="share-square-o"><i class="fa fa-share-square-o"></i></div>
					<div data-help="shield"><i class="fa fa-shield"></i></div>
					<div data-help="ship"><i class="fa fa-ship"></i></div>
					<div data-help="shopping-bag"><i class="fa fa-shopping-bag"></i></div>
					<div data-help="shopping-basket"><i class="fa fa-shopping-basket"></i></div>
					<div data-help="shopping-cart"><i class="fa fa-shopping-cart"></i></div>
					<div data-help="shower"><i class="fa fa-shower"></i></div>
					<div data-help="sign-in"><i class="fa fa-sign-in"></i></div>
					<div data-help="sign-language"><i class="fa fa-sign-language"></i></div>
					<div data-help="sign-out"><i class="fa fa-sign-out"></i></div>
					<div data-help="signal"><i class="fa fa-signal"></i></div>
					<div data-help="sign-language"><i class="fa fa-sign-language"></i></div>
					<div data-help="sitemap"><i class="fa fa-sitemap"></i></div>
					<div data-help="sliders"><i class="fa fa-sliders"></i></div>
					<div data-help="smile-o"><i class="fa fa-smile-o"></i></div>
					<div data-help="snowflake-o"><i class="fa fa-snowflake-o"></i></div>
					<div data-help="futbol-o"><i class="fa fa-futbol-o"></i></div>
					<div data-help="sort"><i class="fa fa-sort"></i></div>
					<div data-help="sort-alpha-asc"><i class="fa fa-sort-alpha-asc"></i></div>
					<div data-help="sort-alpha-desc"><i class="fa fa-sort-alpha-desc"></i></div>
					<div data-help="sort-amount-asc"><i class="fa fa-sort-amount-asc"></i></div>
					<div data-help="sort-amount-desc"><i class="fa fa-sort-amount-desc"></i></div>
					<div data-help="sort-asc"><i class="fa fa-sort-asc"></i></div>
					<div data-help="sort-desc"><i class="fa fa-sort-desc"></i></div>
					<div data-help="sort-desc"><i class="fa fa-sort-desc"></i></div>
					<div data-help="sort-numeric-asc"><i class="fa fa-sort-numeric-asc"></i></div>
					<div data-help="sort-numeric-desc"><i class="fa fa-sort-numeric-desc"></i></div>
					<div data-help="sort-asc"><i class="fa fa-sort-asc"></i></div>
					<div data-help="space-shuttle"><i class="fa fa-space-shuttle"></i></div>
					<div data-help="spinner"><i class="fa fa-spinner"></i></div>
					<div data-help="spoon"><i class="fa fa-spoon"></i></div>
					<div data-help="square"><i class="fa fa-square"></i></div>
					<div data-help="square-o"><i class="fa fa-square-o"></i></div>
					<div data-help="star"><i class="fa fa-star"></i></div>
					<div data-help="star-half"><i class="fa fa-star-half"></i></div>
					<div data-help="star-half-o"><i class="fa fa-star-half-o"></i></div>
					<div data-help="star-half-o"><i class="fa fa-star-half-o"></i></div>
					<div data-help="star-half-o"><i class="fa fa-star-half-o"></i></div>
					<div data-help="star-o"><i class="fa fa-star-o"></i></div>
					<div data-help="sticky-note"><i class="fa fa-sticky-note"></i></div>
					<div data-help="sticky-note-o"><i class="fa fa-sticky-note-o"></i></div>
					<div data-help="street-view"><i class="fa fa-street-view"></i></div>
					<div data-help="suitcase"><i class="fa fa-suitcase"></i></div>
					<div data-help="sun-o"><i class="fa fa-sun-o"></i></div>
					<div data-help="life-ring"><i class="fa fa-life-ring"></i></div>
					<div data-help="tablet"><i class="fa fa-tablet"></i></div>
					<div data-help="tachometer"><i class="fa fa-tachometer"></i></div>
					<div data-help="tag"><i class="fa fa-tag"></i></div>
					<div data-help="tags"><i class="fa fa-tags"></i></div>
					<div data-help="tasks"><i class="fa fa-tasks"></i></div>
					<div data-help="taxi"><i class="fa fa-taxi"></i></div>
					<div data-help="television"><i class="fa fa-television"></i></div>
					<div data-help="terminal"><i class="fa fa-terminal"></i></div>
					<div data-help="thermometer-full"><i class="fa fa-thermometer-full"></i></div>
					<div data-help="thermometer-empty"><i class="fa fa-thermometer-empty"></i></div>
					<div data-help="thermometer-quarter"><i class="fa fa-thermometer-quarter"></i></div>
					<div data-help="thermometer-half"><i class="fa fa-thermometer-half"></i></div>
					<div data-help="thermometer-three-quarters"><i class="fa fa-thermometer-three-quarters"></i></div>
					<div data-help="thermometer-full"><i class="fa fa-thermometer-full"></i></div>
					<div data-help="thermometer-empty"><i class="fa fa-thermometer-empty"></i></div>
					<div data-help="thermometer-full"><i class="fa fa-thermometer-full"></i></div>
					<div data-help="thermometer-half"><i class="fa fa-thermometer-half"></i></div>
					<div data-help="thermometer-quarter"><i class="fa fa-thermometer-quarter"></i></div>
					<div data-help="thermometer-three-quarters"><i class="fa fa-thermometer-three-quarters"></i></div>
					<div data-help="thumb-tack"><i class="fa fa-thumb-tack"></i></div>
					<div data-help="thumbs-down"><i class="fa fa-thumbs-down"></i></div>
					<div data-help="thumbs-o-down"><i class="fa fa-thumbs-o-down"></i></div>
					<div data-help="thumbs-o-up"><i class="fa fa-thumbs-o-up"></i></div>
					<div data-help="thumbs-up"><i class="fa fa-thumbs-up"></i></div>
					<div data-help="ticket"><i class="fa fa-ticket"></i></div>
					<div data-help="times"><i class="fa fa-times"></i></div>
					<div data-help="times-circle"><i class="fa fa-times-circle"></i></div>
					<div data-help="times-circle-o"><i class="fa fa-times-circle-o"></i></div>
					<div data-help="window-close"><i class="fa fa-window-close"></i></div>
					<div data-help="window-close-o"><i class="fa fa-window-close-o"></i></div>
					<div data-help="tint"><i class="fa fa-tint"></i></div>
					<div data-help="caret-square-o-down"><i class="fa fa-caret-square-o-down"></i></div>
					<div data-help="caret-square-o-left"><i class="fa fa-caret-square-o-left"></i></div>
					<div data-help="toggle-off"><i class="fa fa-toggle-off"></i></div>
					<div data-help="toggle-on"><i class="fa fa-toggle-on"></i></div>
					<div data-help="caret-square-o-right"><i class="fa fa-caret-square-o-right"></i></div>
					<div data-help="caret-square-o-up"><i class="fa fa-caret-square-o-up"></i></div>
					<div data-help="trademark"><i class="fa fa-trademark"></i></div>
					<div data-help="trash"><i class="fa fa-trash"></i></div>
					<div data-help="trash-o"><i class="fa fa-trash-o"></i></div>
					<div data-help="tree"><i class="fa fa-tree"></i></div>
					<div data-help="trophy"><i class="fa fa-trophy"></i></div>
					<div data-help="truck"><i class="fa fa-truck"></i></div>
					<div data-help="tty"><i class="fa fa-tty"></i></div>
					<div data-help="television"><i class="fa fa-television"></i></div>
					<div data-help="umbrella"><i class="fa fa-umbrella"></i></div>
					<div data-help="universal-access"><i class="fa fa-universal-access"></i></div>
					<div data-help="university"><i class="fa fa-university"></i></div>
					<div data-help="unlock"><i class="fa fa-unlock"></i></div>
					<div data-help="unlock-alt"><i class="fa fa-unlock-alt"></i></div>
					<div data-help="sort"><i class="fa fa-sort"></i></div>
					<div data-help="upload"><i class="fa fa-upload"></i></div>
					<div data-help="user"><i class="fa fa-user"></i></div>
					<div data-help="user-circle"><i class="fa fa-user-circle"></i></div>
					<div data-help="user-circle-o"><i class="fa fa-user-circle-o"></i></div>
					<div data-help="user-o"><i class="fa fa-user-o"></i></div>
					<div data-help="user-plus"><i class="fa fa-user-plus"></i></div>
					<div data-help="user-secret"><i class="fa fa-user-secret"></i></div>
					<div data-help="user-times"><i class="fa fa-user-times"></i></div>
					<div data-help="users"><i class="fa fa-users"></i></div>
					<div data-help="address-card"><i class="fa fa-address-card"></i></div>
					<div data-help="address-card-o"><i class="fa fa-address-card-o"></i></div>
					<div data-help="video-camera"><i class="fa fa-video-camera"></i></div>
					<div data-help="volume-control-phone"><i class="fa fa-volume-control-phone"></i></div>
					<div data-help="volume-down"><i class="fa fa-volume-down"></i></div>
					<div data-help="volume-off"><i class="fa fa-volume-off"></i></div>
					<div data-help="volume-up"><i class="fa fa-volume-up"></i></div>
					<div data-help="exclamation-triangle"><i class="fa fa-exclamation-triangle"></i></div>
					<div data-help="wheelchair"><i class="fa fa-wheelchair"></i></div>
					<div data-help="wheelchair-alt"><i class="fa fa-wheelchair-alt"></i></div>
					<div data-help="wifi"><i class="fa fa-wifi"></i></div>
					<div data-help="window-close"><i class="fa fa-window-close"></i></div>
					<div data-help="window-close-o"><i class="fa fa-window-close-o"></i></div>
					<div data-help="window-maximize"><i class="fa fa-window-maximize"></i></div>
					<div data-help="window-minimize"><i class="fa fa-window-minimize"></i></div>
					<div data-help="window-restore"><i class="fa fa-window-restore"></i></div>
					<div data-help="wrench"><i class="fa fa-wrench"></i></div>
				</section>


				<!-- Accessibility Icons -->
				<h2><?php _e('Accessibility Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="american-sign-language-interpreting"><i class="fa fa-american-sign-language-interpreting"></i></div>
					<div data-help="american-sign-language-interpreting"><i class="fa fa-american-sign-language-interpreting"></i></div>
					<div data-help="assistive-listening-systems"><i class="fa fa-assistive-listening-systems"></i></div>
					<div data-help="audio-description"><i class="fa fa-audio-description"></i></div>
					<div data-help="blind"><i class="fa fa-blind"></i></div>
					<div data-help="braille"><i class="fa fa-braille"></i></div>
					<div data-help="cc"><i class="fa fa-cc"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="deaf"><i class="fa fa-deaf"></i></div>
					<div data-help="low-vision"><i class="fa fa-low-vision"></i></div>
					<div data-help="question-circle-o"><i class="fa fa-question-circle-o"></i></div>
					<div data-help="sign-language"><i class="fa fa-sign-language"></i></div>
					<div data-help="sign-language"><i class="fa fa-sign-language"></i></div>
					<div data-help="tty"><i class="fa fa-tty"></i></div>
					<div data-help="universal-access"><i class="fa fa-universal-access"></i></div>
					<div data-help="volume-control-phone"><i class="fa fa-volume-control-phone"></i></div>
					<div data-help="wheelchair"><i class="fa fa-wheelchair"></i></div>
					<div data-help="wheelchair-alt"><i class="fa fa-wheelchair-alt"></i></div>
				</section>


				<!-- Hand Icons -->
				<h2><?php _e('Hand Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="hand-rock-o"><i class="fa fa-hand-rock-o"></i></div>
					<div data-help="hand-lizard-o"><i class="fa fa-hand-lizard-o"></i></div>
					<div data-help="hand-o-down"><i class="fa fa-hand-o-down"></i></div>
					<div data-help="hand-o-left"><i class="fa fa-hand-o-left"></i></div>
					<div data-help="hand-o-right"><i class="fa fa-hand-o-right"></i></div>
					<div data-help="hand-o-up"><i class="fa fa-hand-o-up"></i></div>
					<div data-help="hand-paper-o"><i class="fa fa-hand-paper-o"></i></div>
					<div data-help="hand-peace-o"><i class="fa fa-hand-peace-o"></i></div>
					<div data-help="hand-pointer-o"><i class="fa fa-hand-pointer-o"></i></div>
					<div data-help="hand-rock-o"><i class="fa fa-hand-rock-o"></i></div>
					<div data-help="hand-scissors-o"><i class="fa fa-hand-scissors-o"></i></div>
					<div data-help="hand-spock-o"><i class="fa fa-hand-spock-o"></i></div>
					<div data-help="hand-paper-o"><i class="fa fa-hand-paper-o"></i></div>
					<div data-help="thumbs-down"><i class="fa fa-thumbs-down"></i></div>
					<div data-help="thumbs-o-down"><i class="fa fa-thumbs-o-down"></i></div>
					<div data-help="thumbs-o-up"><i class="fa fa-thumbs-o-up"></i></div>
					<div data-help="thumbs-up"><i class="fa fa-thumbs-up"></i></div>
				</section>


				<!-- Transportation Icons -->
				<h2><?php _e('Transportation Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="ambulance"><i class="fa fa-ambulance"></i></div>
					<div data-help="car"><i class="fa fa-car"></i></div>
					<div data-help="bicycle"><i class="fa fa-bicycle"></i></div>
					<div data-help="bus"><i class="fa fa-bus"></i></div>
					<div data-help="taxi"><i class="fa fa-taxi"></i></div>
					<div data-help="car"><i class="fa fa-car"></i></div>
					<div data-help="fighter-jet"><i class="fa fa-fighter-jet"></i></div>
					<div data-help="motorcycle"><i class="fa fa-motorcycle"></i></div>
					<div data-help="plane"><i class="fa fa-plane"></i></div>
					<div data-help="rocket"><i class="fa fa-rocket"></i></div>
					<div data-help="ship"><i class="fa fa-ship"></i></div>
					<div data-help="space-shuttle"><i class="fa fa-space-shuttle"></i></div>
					<div data-help="subway"><i class="fa fa-subway"></i></div>
					<div data-help="taxi"><i class="fa fa-taxi"></i></div>
					<div data-help="train"><i class="fa fa-train"></i></div>
					<div data-help="truck"><i class="fa fa-truck"></i></div>
					<div data-help="wheelchair"><i class="fa fa-wheelchair"></i></div>
					<div data-help="wheelchair-alt"><i class="fa fa-wheelchair-alt"></i></div>
				</section>


				<!-- Gender Icons -->
				<h2><?php _e('Gender Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="genderless"><i class="fa fa-genderless"></i></div>
					<div data-help="transgender"><i class="fa fa-transgender"></i></div>
					<div data-help="mars"><i class="fa fa-mars"></i></div>
					<div data-help="mars-double"><i class="fa fa-mars-double"></i></div>
					<div data-help="mars-stroke"><i class="fa fa-mars-stroke"></i></div>
					<div data-help="mars-stroke-h"><i class="fa fa-mars-stroke-h"></i></div>
					<div data-help="mars-stroke-v"><i class="fa fa-mars-stroke-v"></i></div>
					<div data-help="mercury"><i class="fa fa-mercury"></i></div>
					<div data-help="neuter"><i class="fa fa-neuter"></i></div>
					<div data-help="transgender"><i class="fa fa-transgender"></i></div>
					<div data-help="transgender-alt"><i class="fa fa-transgender-alt"></i></div>
					<div data-help="venus"><i class="fa fa-venus"></i></div>
					<div data-help="venus-double"><i class="fa fa-venus-double"></i></div>
					<div data-help="venus-mars"><i class="fa fa-venus-mars"></i></div>
				</section>


				<!-- File Type Icons -->
				<h2><?php _e('File Type Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="file"><i class="fa fa-file"></i></div>
					<div data-help="file-archive-o"><i class="fa fa-file-archive-o"></i></div>
					<div data-help="file-audio-o"><i class="fa fa-file-audio-o"></i></div>
					<div data-help="file-code-o"><i class="fa fa-file-code-o"></i></div>
					<div data-help="file-excel-o"><i class="fa fa-file-excel-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-video-o"><i class="fa fa-file-video-o"></i></div>
					<div data-help="file-o"><i class="fa fa-file-o"></i></div>
					<div data-help="file-pdf-o"><i class="fa fa-file-pdf-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-image-o"><i class="fa fa-file-image-o"></i></div>
					<div data-help="file-powerpoint-o"><i class="fa fa-file-powerpoint-o"></i></div>
					<div data-help="file-audio-o"><i class="fa fa-file-audio-o"></i></div>
					<div data-help="file-text"><i class="fa fa-file-text"></i></div>
					<div data-help="file-text-o"><i class="fa fa-file-text-o"></i></div>
					<div data-help="file-video-o"><i class="fa fa-file-video-o"></i></div>
					<div data-help="file-word-o"><i class="fa fa-file-word-o"></i></div>
					<div data-help="file-archive-o"><i class="fa fa-file-archive-o"></i></div>
				</section>


				<!-- File Type Icons -->
				<h2><?php _e('Spinner Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="circle-o-notch"><i class="fa fa-circle-o-notch"></i></div>
					<div data-help="cog"><i class="fa fa-cog"></i></div>
					<div data-help="cog"><i class="fa fa-cog"></i></div>
					<div data-help="refresh"><i class="fa fa-refresh"></i></div>
					<div data-help="spinner"><i class="fa fa-spinner"></i></div>
				</section>


				<!-- Form Control Icons -->
				<h2><?php _e('Form Control Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="check-square"><i class="fa fa-check-square"></i></div>
					<div data-help="check-square-o"><i class="fa fa-check-square-o"></i></div>
					<div data-help="circle"><i class="fa fa-circle"></i></div>
					<div data-help="circle-o"><i class="fa fa-circle-o"></i></div>
					<div data-help="dot-circle-o"><i class="fa fa-dot-circle-o"></i></div>
					<div data-help="minus-square"><i class="fa fa-minus-square"></i></div>
					<div data-help="minus-square-o"><i class="fa fa-minus-square-o"></i></div>
					<div data-help="plus-square"><i class="fa fa-plus-square"></i></div>
					<div data-help="plus-square-o"><i class="fa fa-plus-square-o"></i></div>
					<div data-help="square"><i class="fa fa-square"></i></div>
					<div data-help="square-o"><i class="fa fa-square-o"></i></div>
				</section>


				<!-- Payment Icons -->
				<h2><?php _e('Payment Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="cc-amex"><i class="fa fa-cc-amex"></i></div>
					<div data-help="cc-diners-club"><i class="fa fa-cc-diners-club"></i></div>
					<div data-help="cc-discover"><i class="fa fa-cc-discover"></i></div>
					<div data-help="cc-jcb"><i class="fa fa-cc-jcb"></i></div>
					<div data-help="cc-mastercard"><i class="fa fa-cc-mastercard"></i></div>
					<div data-help="cc-paypal"><i class="fa fa-cc-paypal"></i></div>
					<div data-help="cc-stripe"><i class="fa fa-cc-stripe"></i></div>
					<div data-help="cc-visa"><i class="fa fa-cc-visa"></i></div>
					<div data-help="credit-card"><i class="fa fa-credit-card"></i></div>
					<div data-help="credit-card-alt"><i class="fa fa-credit-card-alt"></i></div>
					<div data-help="google-wallet"><i class="fa fa-google-wallet"></i></div>
					<div data-help="paypal"><i class="fa fa-paypal"></i></div>
				</section>


				<!-- Chart Icons -->
				<h2><?php _e('Chart Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="area-chart"><i class="fa fa-area-chart"></i></div>
					<div data-help="bar-chart"><i class="fa fa-bar-chart"></i></div>
					<div data-help="bar-chart"><i class="fa fa-bar-chart"></i></div>
					<div data-help="line-chart"><i class="fa fa-line-chart"></i></div>
					<div data-help="pie-chart"><i class="fa fa-pie-chart"></i></div>
				</section>


				<!-- Currency Icons -->
				<h2><?php _e('Currency Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="btc"><i class="fa fa-btc"></i></div>
					<div data-help="btc"><i class="fa fa-btc"></i></div>
					<div data-help="jpy"><i class="fa fa-jpy"></i></div>
					<div data-help="usd"><i class="fa fa-usd"></i></div>
					<div data-help="eur"><i class="fa fa-eur"></i></div>
					<div data-help="eur"><i class="fa fa-eur"></i></div>
					<div data-help="gbp"><i class="fa fa-gbp"></i></div>
					<div data-help="gg"><i class="fa fa-gg"></i></div>
					<div data-help="gg-circle"><i class="fa fa-gg-circle"></i></div>
					<div data-help="ils"><i class="fa fa-ils"></i></div>
					<div data-help="inr"><i class="fa fa-inr"></i></div>
					<div data-help="jpy"><i class="fa fa-jpy"></i></div>
					<div data-help="krw"><i class="fa fa-krw"></i></div>
					<div data-help="money"><i class="fa fa-money"></i></div>
					<div data-help="jpy"><i class="fa fa-jpy"></i></div>
					<div data-help="rub"><i class="fa fa-rub"></i></div>
					<div data-help="rub"><i class="fa fa-rub"></i></div>
					<div data-help="rub"><i class="fa fa-rub"></i></div>
					<div data-help="inr"><i class="fa fa-inr"></i></div>
					<div data-help="ils"><i class="fa fa-ils"></i></div>
					<div data-help="ils"><i class="fa fa-ils"></i></div>
					<div data-help="try"><i class="fa fa-try"></i></div>
					<div data-help="try"><i class="fa fa-try"></i></div>
					<div data-help="usd"><i class="fa fa-usd"></i></div>
					<div data-help="krw"><i class="fa fa-krw"></i></div>
					<div data-help="jpy"><i class="fa fa-jpy"></i></div>
				</section>


				<!-- Text Editor Icons -->
				<h2><?php _e('Text Editor Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="align-center"><i class="fa fa-align-center"></i></div>
					<div data-help="align-justify"><i class="fa fa-align-justify"></i></div>
					<div data-help="align-left"><i class="fa fa-align-left"></i></div>
					<div data-help="align-right"><i class="fa fa-align-right"></i></div>
					<div data-help="bold"><i class="fa fa-bold"></i></div>
					<div data-help="link"><i class="fa fa-link"></i></div>
					<div data-help="chain-broken"><i class="fa fa-chain-broken"></i></div>
					<div data-help="clipboard"><i class="fa fa-clipboard"></i></div>
					<div data-help="columns"><i class="fa fa-columns"></i></div>
					<div data-help="files-o"><i class="fa fa-files-o"></i></div>
					<div data-help="scissors"><i class="fa fa-scissors"></i></div>
					<div data-help="outdent"><i class="fa fa-outdent"></i></div>
					<div data-help="eraser"><i class="fa fa-eraser"></i></div>
					<div data-help="file"><i class="fa fa-file"></i></div>
					<div data-help="file-o"><i class="fa fa-file-o"></i></div>
					<div data-help="file-text"><i class="fa fa-file-text"></i></div>
					<div data-help="file-text-o"><i class="fa fa-file-text-o"></i></div>
					<div data-help="files-o"><i class="fa fa-files-o"></i></div>
					<div data-help="floppy-o"><i class="fa fa-floppy-o"></i></div>
					<div data-help="font"><i class="fa fa-font"></i></div>
					<div data-help="header"><i class="fa fa-header"></i></div>
					<div data-help="indent"><i class="fa fa-indent"></i></div>
					<div data-help="italic"><i class="fa fa-italic"></i></div>
					<div data-help="link"><i class="fa fa-link"></i></div>
					<div data-help="list"><i class="fa fa-list"></i></div>
					<div data-help="list-alt"><i class="fa fa-list-alt"></i></div>
					<div data-help="list-ol"><i class="fa fa-list-ol"></i></div>
					<div data-help="list-ul"><i class="fa fa-list-ul"></i></div>
					<div data-help="outdent"><i class="fa fa-outdent"></i></div>
					<div data-help="paperclip"><i class="fa fa-paperclip"></i></div>
					<div data-help="paragraph"><i class="fa fa-paragraph"></i></div>
					<div data-help="clipboard"><i class="fa fa-clipboard"></i></div>
					<div data-help="repeat"><i class="fa fa-repeat"></i></div>
					<div data-help="undo"><i class="fa fa-undo"></i></div>
					<div data-help="repeat"><i class="fa fa-repeat"></i></div>
					<div data-help="floppy-o"><i class="fa fa-floppy-o"></i></div>
					<div data-help="scissors"><i class="fa fa-scissors"></i></div>
					<div data-help="strikethrough"><i class="fa fa-strikethrough"></i></div>
					<div data-help="subscript"><i class="fa fa-subscript"></i></div>
					<div data-help="superscript"><i class="fa fa-superscript"></i></div>
					<div data-help="table"><i class="fa fa-table"></i></div>
					<div data-help="text-height"><i class="fa fa-text-height"></i></div>
					<div data-help="text-width"><i class="fa fa-text-width"></i></div>
					<div data-help="th"><i class="fa fa-th"></i></div>
					<div data-help="th-large"><i class="fa fa-th-large"></i></div>
					<div data-help="th-list"><i class="fa fa-th-list"></i></div>
					<div data-help="underline"><i class="fa fa-underline"></i></div>
					<div data-help="undo"><i class="fa fa-undo"></i></div>
					<div data-help="chain-broken"><i class="fa fa-chain-broken"></i></div>
				</section>


				<!-- Directional Icons -->
				<h2><?php _e('Directional Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="angle-double-down"><i class="fa fa-angle-double-down"></i></div>
					<div data-help="angle-double-left"><i class="fa fa-angle-double-left"></i></div>
					<div data-help="angle-double-right"><i class="fa fa-angle-double-right"></i></div>
					<div data-help="angle-double-up"><i class="fa fa-angle-double-up"></i></div>
					<div data-help="angle-down"><i class="fa fa-angle-down"></i></div>
					<div data-help="angle-left"><i class="fa fa-angle-left"></i></div>
					<div data-help="angle-right"><i class="fa fa-angle-right"></i></div>
					<div data-help="angle-up"><i class="fa fa-angle-up"></i></div>
					<div data-help="arrow-circle-down"><i class="fa fa-arrow-circle-down"></i></div>
					<div data-help="arrow-circle-left"><i class="fa fa-arrow-circle-left"></i></div>
					<div data-help="arrow-circle-o-down"><i class="fa fa-arrow-circle-o-down"></i></div>
					<div data-help="arrow-circle-o-left"><i class="fa fa-arrow-circle-o-left"></i></div>
					<div data-help="arrow-circle-o-right"><i class="fa fa-arrow-circle-o-right"></i></div>
					<div data-help="arrow-circle-o-up"><i class="fa fa-arrow-circle-o-up"></i></div>
					<div data-help="arrow-circle-right"><i class="fa fa-arrow-circle-right"></i></div>
					<div data-help="arrow-circle-up"><i class="fa fa-arrow-circle-up"></i></div>
					<div data-help="arrow-down"><i class="fa fa-arrow-down"></i></div>
					<div data-help="arrow-left"><i class="fa fa-arrow-left"></i></div>
					<div data-help="arrow-right"><i class="fa fa-arrow-right"></i></div>
					<div data-help="arrow-up"><i class="fa fa-arrow-up"></i></div>
					<div data-help="arrows"><i class="fa fa-arrows"></i></div>
					<div data-help="arrows-alt"><i class="fa fa-arrows-alt"></i></div>
					<div data-help="arrows-h"><i class="fa fa-arrows-h"></i></div>
					<div data-help="arrows-v"><i class="fa fa-arrows-v"></i></div>
					<div data-help="caret-down"><i class="fa fa-caret-down"></i></div>
					<div data-help="caret-left"><i class="fa fa-caret-left"></i></div>
					<div data-help="caret-right"><i class="fa fa-caret-right"></i></div>
					<div data-help="caret-square-o-down"><i class="fa fa-caret-square-o-down"></i></div>
					<div data-help="caret-square-o-left"><i class="fa fa-caret-square-o-left"></i></div>
					<div data-help="caret-square-o-right"><i class="fa fa-caret-square-o-right"></i></div>
					<div data-help="caret-square-o-up"><i class="fa fa-caret-square-o-up"></i></div>
					<div data-help="caret-up"><i class="fa fa-caret-up"></i></div>
					<div data-help="chevron-circle-down"><i class="fa fa-chevron-circle-down"></i></div>
					<div data-help="chevron-circle-left"><i class="fa fa-chevron-circle-left"></i></div>
					<div data-help="chevron-circle-right"><i class="fa fa-chevron-circle-right"></i></div>
					<div data-help="chevron-circle-up"><i class="fa fa-chevron-circle-up"></i></div>
					<div data-help="chevron-down"><i class="fa fa-chevron-down"></i></div>
					<div data-help="chevron-left"><i class="fa fa-chevron-left"></i></div>
					<div data-help="chevron-right"><i class="fa fa-chevron-right"></i></div>
					<div data-help="chevron-up"><i class="fa fa-chevron-up"></i></div>
					<div data-help="exchange"><i class="fa fa-exchange"></i></div>
					<div data-help="hand-o-down"><i class="fa fa-hand-o-down"></i></div>
					<div data-help="hand-o-left"><i class="fa fa-hand-o-left"></i></div>
					<div data-help="hand-o-right"><i class="fa fa-hand-o-right"></i></div>
					<div data-help="hand-o-up"><i class="fa fa-hand-o-up"></i></div>
					<div data-help="long-arrow-down"><i class="fa fa-long-arrow-down"></i></div>
					<div data-help="long-arrow-left"><i class="fa fa-long-arrow-left"></i></div>
					<div data-help="long-arrow-right"><i class="fa fa-long-arrow-right"></i></div>
					<div data-help="long-arrow-up"><i class="fa fa-long-arrow-up"></i></div>
					<div data-help="caret-square-o-down"><i class="fa fa-caret-square-o-down"></i></div>
					<div data-help="caret-square-o-left"><i class="fa fa-caret-square-o-left"></i></div>
					<div data-help="caret-square-o-right"><i class="fa fa-caret-square-o-right"></i></div>
					<div data-help="caret-square-o-up"><i class="fa fa-caret-square-o-up"></i></div>
				</section>


				<!-- Video Player Icons -->
				<h2><?php _e('Video Player Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="arrows-alt"><i class="fa fa-arrows-alt"></i></div>
					<div data-help="backward"><i class="fa fa-backward"></i></div>
					<div data-help="compress"><i class="fa fa-compress"></i></div>
					<div data-help="eject"><i class="fa fa-eject"></i></div>
					<div data-help="expand"><i class="fa fa-expand"></i></div>
					<div data-help="fast-backward"><i class="fa fa-fast-backward"></i></div>
					<div data-help="fast-forward"><i class="fa fa-fast-forward"></i></div>
					<div data-help="forward"><i class="fa fa-forward"></i></div>
					<div data-help="pause"><i class="fa fa-pause"></i></div>
					<div data-help="pause-circle"><i class="fa fa-pause-circle"></i></div>
					<div data-help="pause-circle-o"><i class="fa fa-pause-circle-o"></i></div>
					<div data-help="play"><i class="fa fa-play"></i></div>
					<div data-help="play-circle"><i class="fa fa-play-circle"></i></div>
					<div data-help="play-circle-o"><i class="fa fa-play-circle-o"></i></div>
					<div data-help="random"><i class="fa fa-random"></i></div>
					<div data-help="step-backward"><i class="fa fa-step-backward"></i></div>
					<div data-help="step-forward"><i class="fa fa-step-forward"></i></div>
					<div data-help="stop"><i class="fa fa-stop"></i></div>
					<div data-help="stop-circle"><i class="fa fa-stop-circle"></i></div>
					<div data-help="stop-circle-o"><i class="fa fa-stop-circle-o"></i></div>
					<div data-help="youtube-play"><i class="fa fa-youtube-play"></i></div>
				</section>


				<!-- Brand Icons -->
				<h2><?php _e('Brand Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="500px"><i class="fa fa-500px"></i></div>
					<div data-help="adn"><i class="fa fa-adn"></i></div>
					<div data-help="amazon"><i class="fa fa-amazon"></i></div>
					<div data-help="android"><i class="fa fa-android"></i></div>
					<div data-help="angellist"><i class="fa fa-angellist"></i></div>
					<div data-help="apple"><i class="fa fa-apple"></i></div>
					<div data-help="bandcamp"><i class="fa fa-bandcamp"></i></div>
					<div data-help="behance"><i class="fa fa-behance"></i></div>
					<div data-help="behance-square"><i class="fa fa-behance-square"></i></div>
					<div data-help="bitbucket"><i class="fa fa-bitbucket"></i></div>
					<div data-help="bitbucket-square"><i class="fa fa-bitbucket-square"></i></div>
					<div data-help="btc"><i class="fa fa-btc"></i></div>
					<div data-help="black-tie"><i class="fa fa-black-tie"></i></div>
					<div data-help="bluetooth"><i class="fa fa-bluetooth"></i></div>
					<div data-help="bluetooth-b"><i class="fa fa-bluetooth-b"></i></div>
					<div data-help="btc"><i class="fa fa-btc"></i></div>
					<div data-help="buysellads"><i class="fa fa-buysellads"></i></div>
					<div data-help="cc-amex"><i class="fa fa-cc-amex"></i></div>
					<div data-help="cc-diners-club"><i class="fa fa-cc-diners-club"></i></div>
					<div data-help="cc-discover"><i class="fa fa-cc-discover"></i></div>
					<div data-help="cc-jcb"><i class="fa fa-cc-jcb"></i></div>
					<div data-help="cc-mastercard"><i class="fa fa-cc-mastercard"></i></div>
					<div data-help="cc-paypal"><i class="fa fa-cc-paypal"></i></div>
					<div data-help="cc-stripe"><i class="fa fa-cc-stripe"></i></div>
					<div data-help="cc-visa"><i class="fa fa-cc-visa"></i></div>
					<div data-help="chrome"><i class="fa fa-chrome"></i></div>
					<div data-help="codepen"><i class="fa fa-codepen"></i></div>
					<div data-help="codiepie"><i class="fa fa-codiepie"></i></div>
					<div data-help="connectdevelop"><i class="fa fa-connectdevelop"></i></div>
					<div data-help="contao"><i class="fa fa-contao"></i></div>
					<div data-help="css3"><i class="fa fa-css3"></i></div>
					<div data-help="dashcube"><i class="fa fa-dashcube"></i></div>
					<div data-help="delicious"><i class="fa fa-delicious"></i></div>
					<div data-help="deviantart"><i class="fa fa-deviantart"></i></div>
					<div data-help="digg"><i class="fa fa-digg"></i></div>
					<div data-help="dribbble"><i class="fa fa-dribbble"></i></div>
					<div data-help="dropbox"><i class="fa fa-dropbox"></i></div>
					<div data-help="drupal"><i class="fa fa-drupal"></i></div>
					<div data-help="edge"><i class="fa fa-edge"></i></div>
					<div data-help="eercast"><i class="fa fa-eercast"></i></div>
					<div data-help="empire"><i class="fa fa-empire"></i></div>
					<div data-help="envira"><i class="fa fa-envira"></i></div>
					<div data-help="etsy"><i class="fa fa-etsy"></i></div>
					<div data-help="expeditedssl"><i class="fa fa-expeditedssl"></i></div>
					<div data-help="font-awesome"><i class="fa fa-font-awesome"></i></div>
					<div data-help="facebook"><i class="fa fa-facebook"></i></div>
					<div data-help="facebook"><i class="fa fa-facebook"></i></div>
					<div data-help="facebook-official"><i class="fa fa-facebook-official"></i></div>
					<div data-help="facebook-square"><i class="fa fa-facebook-square"></i></div>
					<div data-help="firefox"><i class="fa fa-firefox"></i></div>
					<div data-help="first-order"><i class="fa fa-first-order"></i></div>
					<div data-help="flickr"><i class="fa fa-flickr"></i></div>
					<div data-help="font-awesome"><i class="fa fa-font-awesome"></i></div>
					<div data-help="fonticons"><i class="fa fa-fonticons"></i></div>
					<div data-help="fort-awesome"><i class="fa fa-fort-awesome"></i></div>
					<div data-help="forumbee"><i class="fa fa-forumbee"></i></div>
					<div data-help="foursquare"><i class="fa fa-foursquare"></i></div>
					<div data-help="free-code-camp"><i class="fa fa-free-code-camp"></i></div>
					<div data-help="empire"><i class="fa fa-empire"></i></div>
					<div data-help="get-pocket"><i class="fa fa-get-pocket"></i></div>
					<div data-help="gg"><i class="fa fa-gg"></i></div>
					<div data-help="gg-circle"><i class="fa fa-gg-circle"></i></div>
					<div data-help="git"><i class="fa fa-git"></i></div>
					<div data-help="git-square"><i class="fa fa-git-square"></i></div>
					<div data-help="github"><i class="fa fa-github"></i></div>
					<div data-help="github-alt"><i class="fa fa-github-alt"></i></div>
					<div data-help="github-square"><i class="fa fa-github-square"></i></div>
					<div data-help="gitlab"><i class="fa fa-gitlab"></i></div>
					<div data-help="gratipay"><i class="fa fa-gratipay"></i></div>
					<div data-help="glide"><i class="fa fa-glide"></i></div>
					<div data-help="glide-g"><i class="fa fa-glide-g"></i></div>
					<div data-help="google"><i class="fa fa-google"></i></div>
					<div data-help="google-plus"><i class="fa fa-google-plus"></i></div>
					<div data-help="google-plus-official"><i class="fa fa-google-plus-official"></i></div>
					<div data-help="google-plus-official"><i class="fa fa-google-plus-official"></i></div>
					<div data-help="google-plus-square"><i class="fa fa-google-plus-square"></i></div>
					<div data-help="google-wallet"><i class="fa fa-google-wallet"></i></div>
					<div data-help="gratipay"><i class="fa fa-gratipay"></i></div>
					<div data-help="grav"><i class="fa fa-grav"></i></div>
					<div data-help="hacker-news"><i class="fa fa-hacker-news"></i></div>
					<div data-help="houzz"><i class="fa fa-houzz"></i></div>
					<div data-help="html5"><i class="fa fa-html5"></i></div>
					<div data-help="imdb"><i class="fa fa-imdb"></i></div>
					<div data-help="instagram"><i class="fa fa-instagram"></i></div>
					<div data-help="internet-explorer"><i class="fa fa-internet-explorer"></i></div>
					<div data-help="ioxhost"><i class="fa fa-ioxhost"></i></div>
					<div data-help="joomla"><i class="fa fa-joomla"></i></div>
					<div data-help="jsfiddle"><i class="fa fa-jsfiddle"></i></div>
					<div data-help="lastfm"><i class="fa fa-lastfm"></i></div>
					<div data-help="lastfm-square"><i class="fa fa-lastfm-square"></i></div>
					<div data-help="leanpub"><i class="fa fa-leanpub"></i></div>
					<div data-help="linkedin"><i class="fa fa-linkedin"></i></div>
					<div data-help="linkedin-square"><i class="fa fa-linkedin-square"></i></div>
					<div data-help="linode"><i class="fa fa-linode"></i></div>
					<div data-help="linux"><i class="fa fa-linux"></i></div>
					<div data-help="maxcdn"><i class="fa fa-maxcdn"></i></div>
					<div data-help="meanpath"><i class="fa fa-meanpath"></i></div>
					<div data-help="medium"><i class="fa fa-medium"></i></div>
					<div data-help="meetup"><i class="fa fa-meetup"></i></div>
					<div data-help="mixcloud"><i class="fa fa-mixcloud"></i></div>
					<div data-help="modx"><i class="fa fa-modx"></i></div>
					<div data-help="odnoklassniki"><i class="fa fa-odnoklassniki"></i></div>
					<div data-help="odnoklassniki-square"><i class="fa fa-odnoklassniki-square"></i></div>
					<div data-help="opencart"><i class="fa fa-opencart"></i></div>
					<div data-help="openid"><i class="fa fa-openid"></i></div>
					<div data-help="opera"><i class="fa fa-opera"></i></div>
					<div data-help="optin-monster"><i class="fa fa-optin-monster"></i></div>
					<div data-help="pagelines"><i class="fa fa-pagelines"></i></div>
					<div data-help="paypal"><i class="fa fa-paypal"></i></div>
					<div data-help="pied-piper"><i class="fa fa-pied-piper"></i></div>
					<div data-help="pied-piper-alt"><i class="fa fa-pied-piper-alt"></i></div>
					<div data-help="pied-piper-pp"><i class="fa fa-pied-piper-pp"></i></div>
					<div data-help="pinterest"><i class="fa fa-pinterest"></i></div>
					<div data-help="pinterest-p"><i class="fa fa-pinterest-p"></i></div>
					<div data-help="pinterest-square"><i class="fa fa-pinterest-square"></i></div>
					<div data-help="product-hunt"><i class="fa fa-product-hunt"></i></div>
					<div data-help="qq"><i class="fa fa-qq"></i></div>
					<div data-help="quora"><i class="fa fa-quora"></i></div>
					<div data-help="rebel"><i class="fa fa-rebel"></i></div>
					<div data-help="ravelry"><i class="fa fa-ravelry"></i></div>
					<div data-help="rebel"><i class="fa fa-rebel"></i></div>
					<div data-help="reddit"><i class="fa fa-reddit"></i></div>
					<div data-help="reddit-alien"><i class="fa fa-reddit-alien"></i></div>
					<div data-help="reddit-square"><i class="fa fa-reddit-square"></i></div>
					<div data-help="renren"><i class="fa fa-renren"></i></div>
					<div data-help="rebel"><i class="fa fa-rebel"></i></div>
					<div data-help="safari"><i class="fa fa-safari"></i></div>
					<div data-help="scribd"><i class="fa fa-scribd"></i></div>
					<div data-help="sellsy"><i class="fa fa-sellsy"></i></div>
					<div data-help="share-alt"><i class="fa fa-share-alt"></i></div>
					<div data-help="share-alt-square"><i class="fa fa-share-alt-square"></i></div>
					<div data-help="shirtsinbulk"><i class="fa fa-shirtsinbulk"></i></div>
					<div data-help="simplybuilt"><i class="fa fa-simplybuilt"></i></div>
					<div data-help="skyatlas"><i class="fa fa-skyatlas"></i></div>
					<div data-help="skype"><i class="fa fa-skype"></i></div>
					<div data-help="slack"><i class="fa fa-slack"></i></div>
					<div data-help="slideshare"><i class="fa fa-slideshare"></i></div>
					<div data-help="snapchat"><i class="fa fa-snapchat"></i></div>
					<div data-help="snapchat-ghost"><i class="fa fa-snapchat-ghost"></i></div>
					<div data-help="snapchat-square"><i class="fa fa-snapchat-square"></i></div>
					<div data-help="soundcloud"><i class="fa fa-soundcloud"></i></div>
					<div data-help="spotify"><i class="fa fa-spotify"></i></div>
					<div data-help="stack-exchange"><i class="fa fa-stack-exchange"></i></div>
					<div data-help="stack-overflow"><i class="fa fa-stack-overflow"></i></div>
					<div data-help="steam"><i class="fa fa-steam"></i></div>
					<div data-help="steam-square"><i class="fa fa-steam-square"></i></div>
					<div data-help="stumbleupon"><i class="fa fa-stumbleupon"></i></div>
					<div data-help="stumbleupon-circle"><i class="fa fa-stumbleupon-circle"></i></div>
					<div data-help="superpowers"><i class="fa fa-superpowers"></i></div>
					<div data-help="telegram"><i class="fa fa-telegram"></i></div>
					<div data-help="tencent-weibo"><i class="fa fa-tencent-weibo"></i></div>
					<div data-help="themeisle"><i class="fa fa-themeisle"></i></div>
					<div data-help="trello"><i class="fa fa-trello"></i></div>
					<div data-help="tripadvisor"><i class="fa fa-tripadvisor"></i></div>
					<div data-help="tumblr"><i class="fa fa-tumblr"></i></div>
					<div data-help="tumblr-square"><i class="fa fa-tumblr-square"></i></div>
					<div data-help="twitch"><i class="fa fa-twitch"></i></div>
					<div data-help="twitter"><i class="fa fa-twitter"></i></div>
					<div data-help="twitter-square"><i class="fa fa-twitter-square"></i></div>
					<div data-help="usb"><i class="fa fa-usb"></i></div>
					<div data-help="viacoin"><i class="fa fa-viacoin"></i></div>
					<div data-help="viadeo"><i class="fa fa-viadeo"></i></div>
					<div data-help="viadeo-square"><i class="fa fa-viadeo-square"></i></div>
					<div data-help="vimeo"><i class="fa fa-vimeo"></i></div>
					<div data-help="vimeo-square"><i class="fa fa-vimeo-square"></i></div>
					<div data-help="vine"><i class="fa fa-vine"></i></div>
					<div data-help="vk"><i class="fa fa-vk"></i></div>
					<div data-help="weixin"><i class="fa fa-weixin"></i></div>
					<div data-help="weibo"><i class="fa fa-weibo"></i></div>
					<div data-help="weixin"><i class="fa fa-weixin"></i></div>
					<div data-help="whatsapp"><i class="fa fa-whatsapp"></i></div>
					<div data-help="wikipedia-w"><i class="fa fa-wikipedia-w"></i></div>
					<div data-help="windows"><i class="fa fa-windows"></i></div>
					<div data-help="wordpress"><i class="fa fa-wordpress"></i></div>
					<div data-help="wpbeginner"><i class="fa fa-wpbeginner"></i></div>
					<div data-help="wpexplorer"><i class="fa fa-wpexplorer"></i></div>
					<div data-help="wpforms"><i class="fa fa-wpforms"></i></div>
					<div data-help="xing"><i class="fa fa-xing"></i></div>
					<div data-help="xing-square"><i class="fa fa-xing-square"></i></div>
					<div data-help="y-combinator"><i class="fa fa-y-combinator"></i></div>
					<div data-help="hacker-news"><i class="fa fa-hacker-news"></i></div>
					<div data-help="yahoo"><i class="fa fa-yahoo"></i></div>
					<div data-help="y-combinator"><i class="fa fa-y-combinator"></i></div>
					<div data-help="hacker-news"><i class="fa fa-hacker-news"></i></div>
					<div data-help="yelp"><i class="fa fa-yelp"></i></div>
					<div data-help="yoast"><i class="fa fa-yoast"></i></div>
					<div data-help="youtube"><i class="fa fa-youtube"></i></div>
					<div data-help="youtube-play"><i class="fa fa-youtube-play"></i></div>
					<div data-help="youtube-square"><i class="fa fa-youtube-square"></i></div>
				</section>


				<!-- Medical Icons -->
				<h2><?php _e('Medical Icons', 'LayerSlider') ?></h2>
				<section class="clearfix">
					<div data-help="ambulance"><i class="fa fa-ambulance"></i></div>
					<div data-help="h-square"><i class="fa fa-h-square"></i></div>
					<div data-help="heart"><i class="fa fa-heart"></i></div>
					<div data-help="heart-o"><i class="fa fa-heart-o"></i></div>
					<div data-help="heartbeat"><i class="fa fa-heartbeat"></i></div>
					<div data-help="hospital-o"><i class="fa fa-hospital-o"></i></div>
					<div data-help="medkit"><i class="fa fa-medkit"></i></div>
					<div data-help="plus-square"><i class="fa fa-plus-square"></i></div>
					<div data-help="stethoscope"><i class="fa fa-stethoscope"></i></div>
					<div data-help="user-md"><i class="fa fa-user-md"></i></div>
					<div data-help="wheelchair"><i class="fa fa-wheelchair"></i></div>
					<div data-help="wheelchair-alt"><i class="fa fa-wheelchair-alt"></i></div>
				</section>
			</div>
		</div>
	</div>
</script>