<?php
/**
 * layer_slider - Creative Slider content plugin
 *
 * @author    Janos Biro, Balint Polgarfi
 * @copyright (c) 2014-2022 Offlajn.com - All Rights Reserved
 * @license   https://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

class PlgContentLayer_Slider extends JPlugin
{
	public function onContentPrepare($context, &$article, &$params, $page = 0)
	{
		// Don't run this plugin when the content is being indexed
		if ($context == 'com_finder.indexer') {
			return true;
		}

		// Simple performance check to determine whether bot should process further
		if (strpos($article->text, '{creativeslider ') !== false) {
			$article->text = preg_replace_callback('/{creativeslider\s+id="?(.+?)"?}/', [$this, 'onShortcodeMatch'], $article->text);
		}

		if (strpos($article->text, '{cs-navigate') !== false) {
			$article->text = preg_replace(
				'/{cs-navigate\s+id="(.+?)"\s+action="?(.+?)"?}(.+?){\/cs-navigate}/',
				'<a class="ls-navigate" href="javascript:;" onclick="jQuery(\'#layerslider_$1\').layerSlider(parseInt(\'$2\')||\'$2\')">$3</a>',
				$article->text
			);
		}
	}

	protected function onShortcodeMatch($shortcode)
	{
		$attrs = ['style' => 'none'];
		$module = JModuleHelper::getModule('mod_layer_slider', 'CreativeSlider'.rand());
		$module->params = 'slider='.$shortcode[1];
		return JModuleHelper::renderModule($module, $attrs);
	}
}
