<?php
/**
 * com_layer_slider - Creative Slider
 *
 * @author    Janos Biro, Balint Polgarfi
 * @copyright (c) 2014-2022 Offlajn.com - All Rights Reserved
 * @license   https://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

if (!class_exists('ZipArchive')) {
	// missing ZipArchive fix
    class ZipArchive
    {
        const CREATE = 1;
        const OVERWRITE = 8;

        private $jArchive;
        private $archive;
        private $mode;
        private $files;

        public function open($archive, $mode = 0)
        {
            $this->archive = $archive;
            $this->mode = $mode;
            $this->files = [];

            if (!$mode) {
                return file_exists($archive);
            }
        }

        public function extractTo($tmpDir)
        {
            if (!$this->mode) {
                $this->jArchive = new Joomla\Archive\Archive();
                $zip = $this->jArchive->getAdapter('zip');
                return $zip->extract($this->archive, $tmpDir);
            }
        }

        public function addFromString($file, $data)
        {
            $this->files[] = ['name' => $file, 'data' => $data];
        }

        public function addFile($filepath, $file)
        {
            $this->files[] = ['name' => $file, 'data' => file_get_contents($filepath)];
        }

        public function close()
        {
            if ($this->mode) {
                $zip = $this->jArchive->getAdapter('zip');
                $zip->create($this->archive, $this->files);
            }
        }
    }
}

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_layer_slider')) {
    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
}

// Include dependancies
$controller = JControllerLegacy::getInstance('Layer_Slider');
$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();
