<?php
/**
 * com_layer_slider - Creative Slider
 *
 * @author    Janos Biro, Balint Polgarfi
 * @copyright (c) 2014-2022 Offlajn.com - All Rights Reserved
 * @license   https://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

class Layer_SliderViewSliders extends JViewLegacy
{
    /**
     * Display the view
     */
    public function display($tpl = null)
    {
        // Check for errors.
        $errors = $this->get('Errors');
        if ($errors) {
            throw new Exception(implode("\n", $errors));
        }

        $GLOBALS['ls_screen'] = (object) [
            'id' => 'toplevel_page_layerslider',
            'base' => 'toplevel_page_layerslider',
        ];

        // simulate wp page
        ${'_GET'}['page'] = 'layerslider';

        parent::display($tpl);

        if ($this->getLayout() !== 'modal') {
            $this->addToolbar();
        }
    }

    /**
     * Add the page title and toolbar.
     */
    protected function addToolbar()
    {
        JToolbarHelper::title('Creative Slider', 'pictures');
    }
}
