<?php
/**
 * layer_slider - Creative Slider button plugin
 *
 * @author    Janos Biro, Balint Polgarfi
 * @copyright (c) 2014-2022 Offlajn.com - All Rights Reserved
 * @license   https://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

class PlgButtonLayer_Slider extends JPlugin
{
	protected $autoloadLanguage = true;

	public function onDisplay($name)
	{
		$button = new JObject();
		$button->modal = true;
		$button->class = 'btn';
		$button->link = 'index.php?option=com_layer_slider&view=sliderlist&tmpl=component';
		$button->text = 'Creative Slider';
		$button->title = 'Insert Creative Slider';
		$button->name = $this->_type . '_' . $this->_name;
		$button->icon = 'pictures';
		$button->options = [
			'height' => '300px',
			'width' => '800px',
			'bodyHeight' => '70',
			'modalWidth' => '80',
		];
		return $button;
	}
}
